/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.model;

import io.camunda.connector.feel.annotation.FEEL;
import io.camunda.connector.generator.dsl.Property;
import io.camunda.connector.generator.java.annotation.TemplateProperty;
import io.camunda.connector.http.base.auth.Authentication;
import io.camunda.connector.http.base.model.HttpMethod;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Map;
import java.util.Objects;

public class HttpCommonRequest {
    @FEEL
    @NotNull
    @TemplateProperty(group="endpoint", id="method", defaultValue="GET")
    private HttpMethod method;
    @FEEL
    @NotBlank
    @Pattern(regexp="^(=|http://|https://|secrets|\\{\\{).*$", message="Must be a http(s) URL")
    @TemplateProperty(group="endpoint", label="URL")
    private @NotBlank @Pattern(regexp="^(=|http://|https://|secrets|\\{\\{).*$", message="Must be a http(s) URL") String url;
    @Valid
    private Authentication authentication;
    @TemplateProperty(group="timeout", label="Connection timeout in seconds", defaultValue="20", constraints=@TemplateProperty.PropertyConstraints(notEmpty=true), description="Defines the connection timeout in seconds, or 0 for an infinite timeout")
    private Integer connectionTimeoutInSeconds;
    @TemplateProperty(group="timeout", label="Read timeout in seconds", defaultValue="20", constraints=@TemplateProperty.PropertyConstraints(notEmpty=true), description="Timeout in seconds to read data from an established connection or 0 for an infinite timeout")
    private Integer readTimeoutInSeconds;
    @TemplateProperty(group="timeout", label="Write timeout in seconds", defaultValue="0", constraints=@TemplateProperty.PropertyConstraints(notEmpty=true), condition=@TemplateProperty.PropertyCondition(property="method", oneOf={"POST", "PUT", "PATCH"}), description="Timeout in seconds to set data or 0 for an infinite timeout")
    private Integer writeTimeoutInSeconds;
    @FEEL
    @TemplateProperty(feel=Property.FeelMode.required, group="endpoint", optional=true, description="Map of HTTP headers to add to the request")
    private Map<String, String> headers;
    @FEEL
    @TemplateProperty(label="Request body", description="Payload to send with the request", feel=Property.FeelMode.optional, group="payload", type=TemplateProperty.PropertyType.Text, optional=true, condition=@TemplateProperty.PropertyCondition(property="method", oneOf={"POST", "PUT", "PATCH"}))
    private Object body;
    @FEEL
    @TemplateProperty(feel=Property.FeelMode.required, group="endpoint", optional=true, description="Map of query parameters to add to the request URL")
    private Map<String, String> queryParameters;

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public boolean hasQueryParameters() {
        return this.queryParameters != null;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public boolean hasAuthentication() {
        return this.authentication != null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public Integer getConnectionTimeoutInSeconds() {
        return this.connectionTimeoutInSeconds;
    }

    public void setConnectionTimeoutInSeconds(Integer connectionTimeoutInSeconds) {
        this.connectionTimeoutInSeconds = connectionTimeoutInSeconds;
    }

    public Integer getReadTimeoutInSeconds() {
        return this.readTimeoutInSeconds;
    }

    public void setReadTimeoutInSeconds(Integer readTimeoutInSeconds) {
        this.readTimeoutInSeconds = readTimeoutInSeconds;
    }

    public Integer getWriteTimeoutInSeconds() {
        return this.writeTimeoutInSeconds;
    }

    public void setWriteTimeoutInSeconds(Integer writeTimeoutInSeconds) {
        this.writeTimeoutInSeconds = writeTimeoutInSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpCommonRequest that = (HttpCommonRequest)o;
        return this.url.equals(that.url) && this.method.equals((Object)that.method) && Objects.equals(this.authentication, that.authentication) && Objects.equals(this.connectionTimeoutInSeconds, that.connectionTimeoutInSeconds) && Objects.equals(this.headers, that.headers) && Objects.equals(this.body, that.body) && Objects.equals(this.queryParameters, that.queryParameters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.method, this.authentication, this.connectionTimeoutInSeconds, this.headers, this.body, this.queryParameters});
    }

    public String toString() {
        return "HttpRequest{url='" + this.url + "', method='" + String.valueOf((Object)this.method) + "', authentication=" + String.valueOf(this.authentication) + ", connectionTimeoutInSeconds='" + this.connectionTimeoutInSeconds + "', headers=" + String.valueOf(this.headers) + ", body=" + String.valueOf(this.body) + ", queryParameters=" + String.valueOf(this.queryParameters) + "}";
    }
}

