/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.blocklist.factory;

import io.camunda.connector.http.base.blocklist.block.Block;
import io.camunda.connector.http.base.blocklist.block.PortBlock;
import io.camunda.connector.http.base.blocklist.block.RegexBlock;
import io.camunda.connector.http.base.blocklist.block.UrlBlock;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlockFactory {
    private static final Logger logger = LoggerFactory.getLogger(BlockFactory.class);
    private static final String URL_TYPE = "URL";
    private static final String PORT_TYPE = "PORT";
    private static final String REGEX_TYPE = "REGEX";

    private BlockFactory() {
    }

    public static Block createBlock(String blockType, String blockRule, String blockName) {
        Objects.requireNonNull(blockType, "value must not be null");
        Objects.requireNonNull(blockRule, "value must not be null");
        return switch (blockType) {
            case URL_TYPE -> new UrlBlock(blockRule, blockName);
            case PORT_TYPE -> PortBlock.create(blockRule, blockName);
            case REGEX_TYPE -> RegexBlock.create(blockRule, blockName);
            default -> {
                logger.warn("Unknown block type: {}", (Object)blockType);
                throw new IllegalArgumentException("Unknown block type: " + blockType);
            }
        };
    }
}

