/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.auth;

import com.google.api.client.http.HttpHeaders;
import io.camunda.connector.feel.annotation.FEEL;
import io.camunda.connector.generator.java.annotation.TemplateProperty;
import io.camunda.connector.generator.java.annotation.TemplateSubType;
import io.camunda.connector.http.base.auth.Authentication;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Pattern;
import java.util.HashMap;
import java.util.Map;

@TemplateSubType(id="oauth-client-credentials-flow", label="OAuth 2.0")
public record OAuthAuthentication(@FEEL @NotEmpty @Pattern(regexp="^(=|http://|https://|secrets|\\{\\{).*$", message="Must be a http(s) URL") @TemplateProperty(group="authentication", description="The OAuth token endpoint", label="OAuth 2.0 token endpoint") @NotEmpty @Pattern(regexp="^(=|http://|https://|secrets|\\{\\{).*$", message="Must be a http(s) URL") String oauthTokenEndpoint, @FEEL @NotEmpty @TemplateProperty(group="authentication", description="Your application's client ID from the OAuth client", label="Client ID") String clientId, @FEEL @NotEmpty @TemplateProperty(group="authentication", description="Your application's client secret from the OAuth client", label="Client secret") String clientSecret, @FEEL @TemplateProperty(group="authentication", description="The unique identifier of the target API you want to access", optional=true) String audience, @FEEL @NotEmpty @TemplateProperty(group="authentication", type=TemplateProperty.PropertyType.Dropdown, choices={@TemplateProperty.DropdownPropertyChoice(value="credentialsBody", label="Send client credentials in body"), @TemplateProperty.DropdownPropertyChoice(value="basicAuthHeader", label="Send as Basic Auth header")}, description="Send client ID and client secret as Basic Auth request in the header, or as client credentials in the request body") String clientAuthentication, @TemplateProperty(group="authentication", description="The scopes which you want to request authorization for (e.g.read:contacts)", optional=true) String scopes) implements Authentication
{
    @TemplateProperty(ignore=true)
    public static final String TYPE = "oauth-client-credentials-flow";
    @TemplateProperty(ignore=true)
    public static final String GRANT_TYPE = "client_credentials";

    @Override
    public void setHeaders(HttpHeaders headers) {
    }

    public Map<String, String> getDataForAuthRequestBody() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("grant_type", GRANT_TYPE);
        data.put("audience", this.audience());
        data.put("scope", this.scopes());
        if ("credentialsBody".equals(this.clientAuthentication())) {
            data.put("client_id", this.clientId());
            data.put("client_secret", this.clientSecret());
        }
        return data;
    }
}

