/*
 * Decompiled with CFR 0.152.
 */
package connector.com.fasterxml.jackson.databind.deser.impl;

import connector.com.fasterxml.jackson.databind.BeanProperty;
import connector.com.fasterxml.jackson.databind.DeserializationContext;
import connector.com.fasterxml.jackson.databind.JavaType;
import connector.com.fasterxml.jackson.databind.JsonMappingException;
import connector.com.fasterxml.jackson.databind.PropertyName;
import connector.com.fasterxml.jackson.databind.deser.NullValueProvider;
import connector.com.fasterxml.jackson.databind.exc.InvalidNullException;
import connector.com.fasterxml.jackson.databind.util.AccessPattern;
import java.io.Serializable;

public class NullsFailProvider
implements NullValueProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final PropertyName _name;
    protected final JavaType _type;

    protected NullsFailProvider(PropertyName name, JavaType type) {
        this._name = name;
        this._type = type;
    }

    public static NullsFailProvider constructForProperty(BeanProperty prop) {
        return NullsFailProvider.constructForProperty(prop, prop.getType());
    }

    public static NullsFailProvider constructForProperty(BeanProperty prop, JavaType type) {
        return new NullsFailProvider(prop.getFullName(), type);
    }

    public static NullsFailProvider constructForRootValue(JavaType t2) {
        return new NullsFailProvider(null, t2);
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public Object getNullValue(DeserializationContext ctxt) throws JsonMappingException {
        throw InvalidNullException.from(ctxt, this._name, this._type);
    }
}

