/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.services;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.UrlEncodedContent;
import connector.com.fasterxml.jackson.databind.JsonNode;
import connector.com.fasterxml.jackson.databind.ObjectMapper;
import connector.com.fasterxml.jackson.databind.node.ObjectNode;
import io.camunda.connector.http.base.auth.CustomAuthentication;
import io.camunda.connector.http.base.auth.OAuthAuthentication;
import io.camunda.connector.http.base.model.HttpCommonRequest;
import io.camunda.connector.http.base.model.HttpMethod;
import io.camunda.connector.http.base.utils.JsonHelper;
import io.camunda.connector.http.base.utils.ResponseParser;
import io.camunda.connector.http.base.utils.Timeout;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationService.class);
    private final ObjectMapper objectMapper;
    private final HttpRequestFactory requestFactory;

    public AuthenticationService(ObjectMapper objectMapper, HttpRequestFactory requestFactory) {
        this.objectMapper = objectMapper;
        this.requestFactory = requestFactory;
    }

    public String extractOAuthAccessToken(HttpResponse oauthResponse) throws IOException {
        return Optional.ofNullable(JsonHelper.getAsJsonElement(oauthResponse.parseAsString(), this.objectMapper)).map(jsonNode -> jsonNode.findValue("access_token").asText()).orElse(null);
    }

    @Deprecated
    public void fillRequestFromCustomAuthResponseData(HttpCommonRequest request, CustomAuthentication authentication, HttpResponse httpResponse) throws IOException {
        Map<String, String> body;
        String strResponse = httpResponse.parseAsString();
        Map<String, String> headers = ResponseParser.extractPropertiesFromBody(authentication.getOutputHeaders(), strResponse, this.objectMapper);
        if (headers != null) {
            if (!request.hasHeaders()) {
                request.setHeaders(new HashMap<String, String>());
            }
            request.getHeaders().putAll(headers);
        }
        if ((body = ResponseParser.extractPropertiesFromBody(authentication.getOutputBody(), strResponse, this.objectMapper)) != null) {
            JsonNode requestBodyAsNode;
            if (!request.hasBody()) {
                request.setBody(new Object());
            }
            if ((requestBodyAsNode = this.objectMapper.readTree(request.getBody().toString())) instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)requestBodyAsNode;
                body.forEach(objectNode::put);
                request.setBody(this.objectMapper.writeValueAsString(objectNode));
            } else {
                LOGGER.error("Wasn't able to append body params. Request body: {}; response: {}", (Object)requestBodyAsNode, (Object)body);
            }
        }
    }

    public HttpRequest createOAuthRequest(HttpCommonRequest request) throws IOException {
        OAuthAuthentication authentication = (OAuthAuthentication)request.getAuthentication();
        GenericUrl genericUrl = new GenericUrl(authentication.getOauthTokenEndpoint());
        Map<String, String> data = authentication.getDataForAuthRequestBody();
        UrlEncodedContent content = new UrlEncodedContent(data);
        HttpRequest httpRequest = this.requestFactory.buildRequest(HttpMethod.POST.name(), genericUrl, content);
        httpRequest.setFollowRedirects(false);
        Timeout.setTimeout(request, httpRequest);
        HttpHeaders headers = new HttpHeaders();
        if ("basicAuthHeader".equals(authentication.getClientAuthentication())) {
            headers.setBasicAuthentication(authentication.getClientId(), authentication.getClientSecret());
        }
        headers.setContentType("application/x-www-form-urlencoded");
        httpRequest.setHeaders(headers);
        return httpRequest;
    }
}

