/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.model;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import io.camunda.connector.http.base.model.HttpMethod;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public final class HttpRequestBuilder {
    private HttpMethod method;
    private GenericUrl genericUrl;
    private HttpHeaders headers;
    private HttpContent content;
    private Integer connectionTimeoutInSeconds;
    private boolean followRedirects;

    public HttpRequestBuilder method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public HttpRequestBuilder genericUrl(GenericUrl genericUrl) {
        this.genericUrl = genericUrl;
        return this;
    }

    public HttpRequestBuilder headers(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public HttpRequestBuilder content(HttpContent content) {
        this.content = content;
        return this;
    }

    public HttpRequestBuilder connectionTimeoutInSeconds(Integer connectionTimeoutInSeconds) {
        this.connectionTimeoutInSeconds = connectionTimeoutInSeconds;
        return this;
    }

    public HttpRequestBuilder followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public HttpRequest build(HttpRequestFactory requestFactory) throws IOException {
        HttpRequest httpRequest = requestFactory.buildRequest(this.method.name(), this.genericUrl, this.content);
        httpRequest.setFollowRedirects(this.followRedirects);
        if (this.headers != null) {
            httpRequest.setHeaders(this.headers);
        }
        if (this.connectionTimeoutInSeconds != null) {
            long connectionTimeout = TimeUnit.SECONDS.toMillis(this.connectionTimeoutInSeconds.intValue());
            int intConnectionTimeout = Math.toIntExact(connectionTimeout);
            httpRequest.setConnectTimeout(intConnectionTimeout);
            httpRequest.setReadTimeout(intConnectionTimeout);
            httpRequest.setWriteTimeout(intConnectionTimeout);
        }
        return httpRequest;
    }
}

