/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.blocklist.block;

import com.google.api.client.http.GenericUrl;
import io.camunda.connector.http.base.blocklist.block.Block;
import io.camunda.connector.http.base.blocklist.util.BlocklistExceptionHelper;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public record RegexBlock(String blockName, Pattern pattern) implements Block
{
    public static RegexBlock create(String value, String blockName) {
        Objects.requireNonNull(value, "value must not be null");
        Objects.requireNonNull(blockName, "blockName must not be null");
        try {
            Pattern pattern = Pattern.compile(value);
            return new RegexBlock(blockName, pattern);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid regular expression provided for block: " + blockName, e);
        }
    }

    @Override
    public void validate(GenericUrl url) {
        if (this.pattern.matcher(url.build()).matches()) {
            BlocklistExceptionHelper.throwBlocklistException("URL", this.blockName);
        }
    }
}

