/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.blocklist.block;

import com.google.api.client.http.GenericUrl;
import io.camunda.connector.http.base.blocklist.block.Block;
import io.camunda.connector.http.base.blocklist.util.BlocklistExceptionHelper;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record PortBlock(String blockName, Set<Integer> blockedPorts) implements Block
{
    private static final Logger logger = LoggerFactory.getLogger(PortBlock.class);

    public static PortBlock create(String value, String blockName) {
        Objects.requireNonNull(value, "value must not be null");
        Objects.requireNonNull(blockName, "blockName must not be null");
        Set<Integer> blockedPorts = Arrays.stream(value.split(",")).map(String::trim).map(portStr -> {
            try {
                int parsedPort = Integer.parseInt(portStr);
                if (parsedPort < 0 || parsedPort > 65535) {
                    logger.warn("Invalid port number {} provided for block: {}", (Object)parsedPort, (Object)blockName);
                    return null;
                }
                return parsedPort;
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid port format provided for block: {} - {}", (Object)blockName, (Object)e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (blockedPorts.isEmpty()) {
            throw new IllegalArgumentException("No valid ports provided for block: " + blockName);
        }
        return new PortBlock(blockName, blockedPorts);
    }

    @Override
    public void validate(GenericUrl url) {
        if (this.blockedPorts.contains(url.getPort())) {
            BlocklistExceptionHelper.throwBlocklistException("port", this.blockName);
        }
    }
}

