/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.blocklist;

import com.google.api.client.http.GenericUrl;
import io.camunda.connector.http.base.blocklist.HttpBlockListManager;
import io.camunda.connector.http.base.blocklist.block.Block;
import io.camunda.connector.http.base.blocklist.factory.BlockFactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpBlocklistManager
implements HttpBlockListManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHttpBlocklistManager.class);
    private static final String BLOCK_PREFIX = "CAMUNDA_CONNECTOR_HTTP_BLOCK_";
    private final List<Block> blockList;

    public DefaultHttpBlocklistManager() {
        this(System.getenv());
    }

    public DefaultHttpBlocklistManager(Map<String, String> environment) {
        this.blockList = this.loadBlocklistFromEnv(environment);
    }

    private List<Block> loadBlocklistFromEnv(Map<String, String> environment) {
        return environment.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(BLOCK_PREFIX)).map(this::createBlockFromEnvEntry).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Block createBlockFromEnvEntry(Map.Entry<String, String> entry) {
        String remaining = entry.getKey().substring(BLOCK_PREFIX.length());
        String[] parts = remaining.split("_", 2);
        String blockType = parts[0];
        String blockName = parts.length > 1 ? parts[1] : "";
        try {
            return BlockFactory.createBlock(blockType, entry.getValue(), blockName);
        }
        catch (Exception e) {
            logger.warn("Failed to create block of type {}: {}", (Object)blockType, (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public void validateUrlAgainstBlocklist(GenericUrl url) {
        for (Block block : this.blockList) {
            block.validate(url);
        }
    }

    public List<Block> getBlockList() {
        return this.blockList;
    }
}

