/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.auth;

import com.google.api.client.http.HttpHeaders;
import io.camunda.connector.feel.annotation.FEEL;
import io.camunda.connector.generator.java.annotation.TemplateProperty;
import io.camunda.connector.generator.java.annotation.TemplateSubType;
import io.camunda.connector.http.base.auth.Authentication;
import jakarta.validation.constraints.NotEmpty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@TemplateSubType(id="oauth-client-credentials-flow", label="OAuth 2.0")
public final class OAuthAuthentication
extends Authentication {
    @TemplateProperty(ignore=true)
    private final String grantType = "client_credentials";
    @FEEL
    @NotEmpty
    @TemplateProperty(group="authentication", description="The OAuth token endpoint")
    private String oauthTokenEndpoint;
    @FEEL
    @NotEmpty
    @TemplateProperty(group="authentication", description="Your application's client ID from the OAuth client")
    private String clientId;
    @FEEL
    @NotEmpty
    @TemplateProperty(group="authentication", description="Your application's client secret from the OAuth client")
    private String clientSecret;
    @FEEL
    @TemplateProperty(group="authentication", description="The unique identifier of the target API you want to access", optional=true)
    private String audience;
    @FEEL
    @NotEmpty
    @TemplateProperty(group="authentication", type=TemplateProperty.PropertyType.Dropdown, choices={@TemplateProperty.DropdownPropertyChoice(value="credentialsBody", label="Send client credentials in body"), @TemplateProperty.DropdownPropertyChoice(value="basicAuthHeader", label="Send as Basic Auth header")}, description="Send client ID and client secret as Basic Auth request in the header, or as client credentials in the request body")
    private String clientAuthentication;
    @TemplateProperty(group="authentication", description="The scopes which you want to request authorization for (e.g.read:contacts)", optional=true)
    private String scopes;
    @TemplateProperty(ignore=true)
    public static final String TYPE = "oauth-client-credentials-flow";

    public Map<String, String> getDataForAuthRequestBody() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("grant_type", this.getGrantType());
        data.put("audience", this.getAudience());
        data.put("scope", this.getScopes());
        if ("credentialsBody".equals(this.getClientAuthentication())) {
            data.put("client_id", this.getClientId());
            data.put("client_secret", this.getClientSecret());
        }
        return data;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getGrantType() {
        return "client_credentials";
    }

    public String getOauthTokenEndpoint() {
        return this.oauthTokenEndpoint;
    }

    public void setOauthTokenEndpoint(String oauthTokenEndpoint) {
        this.oauthTokenEndpoint = oauthTokenEndpoint;
    }

    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getClientAuthentication() {
        return this.clientAuthentication;
    }

    public void setClientAuthentication(String clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
    }

    @Override
    public void setHeaders(HttpHeaders headers) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthAuthentication that = (OAuthAuthentication)o;
        return this.oauthTokenEndpoint.equals(that.oauthTokenEndpoint) && this.clientId.equals(that.clientId) && this.clientSecret.equals(that.clientSecret) && this.audience.equals(that.audience) && Objects.equals("client_credentials", that.grantType) && this.clientAuthentication.equals(that.clientAuthentication) && Objects.equals(this.scopes, that.scopes);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.oauthTokenEndpoint, this.clientId, this.clientSecret, this.audience, "client_credentials", this.clientAuthentication, this.scopes);
    }

    public String toString() {
        return "OAuthAuthentication{grantType='client_credentials', oauthTokenEndpoint='" + this.oauthTokenEndpoint + "', audience='" + this.audience + "', clientAuthentication='" + this.clientAuthentication + "', scopes='" + this.scopes + "'} " + super.toString();
    }
}

