/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.auth;

import com.google.api.client.http.HttpHeaders;
import com.google.common.base.Objects;
import io.camunda.connector.feel.annotation.FEEL;
import io.camunda.connector.generator.java.annotation.TemplateProperty;
import io.camunda.connector.generator.java.annotation.TemplateSubType;
import io.camunda.connector.http.base.auth.Authentication;
import jakarta.validation.constraints.NotEmpty;

@TemplateSubType(id="bearer", label="Bearer token")
public final class BearerAuthentication
extends Authentication {
    @FEEL
    @NotEmpty
    @TemplateProperty(group="authentication", label="Bearer token")
    private String token;
    @TemplateProperty(ignore=true)
    public static final String TYPE = "bearer";

    @Override
    public void setHeaders(HttpHeaders headers) {
        headers.setAuthorization("Bearer " + this.token);
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BearerAuthentication that = (BearerAuthentication)o;
        return Objects.equal(this.token, that.token);
    }

    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.token);
    }

    public String toString() {
        return "BearerAuthentication{token='[REDACTED]'}; Super: " + super.toString();
    }
}

