/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.auth;

import com.google.api.client.http.HttpHeaders;
import com.google.common.base.Objects;
import io.camunda.connector.feel.annotation.FEEL;
import io.camunda.connector.generator.java.annotation.TemplateProperty;
import io.camunda.connector.generator.java.annotation.TemplateSubType;
import io.camunda.connector.http.base.auth.Authentication;
import jakarta.validation.constraints.NotEmpty;
import java.util.function.Function;

@TemplateSubType(id="basic", label="Basic")
public final class BasicAuthentication
extends Authentication {
    @TemplateProperty(ignore=true)
    private static final String SPEC_PASSWORD_EMPTY_PATTERN = "SPEC_PASSWORD_EMPTY_PATTERN";
    @TemplateProperty(ignore=true)
    private static final Function<String, String> SPEC_PASSWORD = psw -> psw.equals(SPEC_PASSWORD_EMPTY_PATTERN) ? "" : psw;
    @FEEL
    @NotEmpty
    @TemplateProperty(group="authentication")
    private String username;
    @FEEL
    @NotEmpty
    @TemplateProperty(group="authentication")
    private String password;
    @TemplateProperty(ignore=true)
    public static final String TYPE = "basic";

    @Override
    public void setHeaders(HttpHeaders headers) {
        headers.setBasicAuthentication(this.username, SPEC_PASSWORD.apply(this.password));
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BasicAuthentication that = (BasicAuthentication)o;
        return Objects.equal(this.username, that.username) && Objects.equal(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.username, this.password);
    }

    public String toString() {
        return "BasicAuthentication {username='[REDACTED]', password='[REDACTED]'}; Super: " + super.toString();
    }
}

