/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl;

import connector.com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record PropertyConstraints(Boolean notEmpty, Integer minLength, Integer maxLength, Pattern pattern) {
    public static PropertyConstraintsBuilder builder() {
        return new PropertyConstraintsBuilder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Pattern(String value, String message) {
    }

    public static class PropertyConstraintsBuilder {
        private Boolean notEmpty;
        private Integer minLength;
        private Integer maxLength;
        private Pattern pattern;

        private PropertyConstraintsBuilder() {
        }

        public static PropertyConstraintsBuilder create() {
            return new PropertyConstraintsBuilder();
        }

        public PropertyConstraintsBuilder notEmpty(boolean notEmpty) {
            this.notEmpty = notEmpty;
            return this;
        }

        public PropertyConstraintsBuilder minLength(int minLength) {
            this.minLength = minLength;
            return this;
        }

        public PropertyConstraintsBuilder maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public PropertyConstraintsBuilder pattern(Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public PropertyConstraints build() {
            return new PropertyConstraints(this.notEmpty, this.minLength, this.maxLength, this.pattern);
        }
    }
}

