/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl;

import io.camunda.connector.generator.dsl.BpmnType;
import io.camunda.connector.generator.dsl.ElementTemplateIcon;
import io.camunda.connector.generator.dsl.HiddenProperty;
import io.camunda.connector.generator.dsl.OutboundElementTemplate;
import io.camunda.connector.generator.dsl.Property;
import io.camunda.connector.generator.dsl.PropertyBinding;
import io.camunda.connector.generator.dsl.PropertyGroup;
import io.camunda.connector.generator.dsl.StringProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class OutboundElementTemplateBuilder {
    private String id;
    private String name;
    private int version;
    private ElementTemplateIcon icon;
    private String documentationRef;
    private String description;
    private Set<String> appliesTo;
    private String elementType;
    private final List<PropertyGroup> groups = new ArrayList<PropertyGroup>();
    private final List<Property> properties = new ArrayList<Property>();

    private OutboundElementTemplateBuilder() {
    }

    public static OutboundElementTemplateBuilder create() {
        return new OutboundElementTemplateBuilder();
    }

    public OutboundElementTemplateBuilder id(String id) {
        this.id = id;
        return this;
    }

    public OutboundElementTemplateBuilder type(String type, boolean configurable) {
        Property property;
        if (this.isTypeAssigned()) {
            throw new IllegalStateException("type is already assigned");
        }
        if (configurable) {
            this.groups.add(0, PropertyGroup.builder().id("taskDefinitionType").label("Task definition type").build());
            property = StringProperty.builder().binding(PropertyBinding.ZeebeTaskDefinitionType.INSTANCE).value(type).id("taskDefinitionType").group("taskDefinitionType").feel(Property.FeelMode.disabled).build();
        } else {
            property = HiddenProperty.builder().binding(PropertyBinding.ZeebeTaskDefinitionType.INSTANCE).value(type).build();
        }
        this.properties.add(property);
        return this;
    }

    public OutboundElementTemplateBuilder type(String type) {
        return this.type(type, false);
    }

    public OutboundElementTemplateBuilder name(String name) {
        this.name = name;
        return this;
    }

    public OutboundElementTemplateBuilder version(int version) {
        this.version = version;
        return this;
    }

    public OutboundElementTemplateBuilder icon(ElementTemplateIcon icon) {
        this.icon = icon;
        return this;
    }

    public OutboundElementTemplateBuilder documentationRef(String documentationRef) {
        this.documentationRef = documentationRef;
        return this;
    }

    public OutboundElementTemplateBuilder description(String description) {
        this.description = description;
        return this;
    }

    public OutboundElementTemplateBuilder appliesTo(Set<String> appliesTo) {
        this.appliesTo = appliesTo;
        return this;
    }

    public OutboundElementTemplateBuilder appliesTo(BpmnType ... appliesTo) {
        this.appliesTo = Arrays.stream(appliesTo).map(BpmnType::getName).collect(Collectors.toSet());
        return this;
    }

    public OutboundElementTemplateBuilder elementType(String elementType) {
        this.elementType = elementType;
        return this;
    }

    public OutboundElementTemplateBuilder elementType(BpmnType elementType) {
        this.elementType = elementType.getName();
        return this;
    }

    public OutboundElementTemplateBuilder propertyGroups(PropertyGroup ... groups) {
        this.groups.addAll(Arrays.asList(groups));
        this.properties.addAll(this.groups.stream().flatMap(group -> group.properties().stream()).toList());
        return this;
    }

    public OutboundElementTemplateBuilder propertyGroups(Collection<PropertyGroup> groups) {
        this.groups.addAll(groups);
        this.properties.addAll(this.groups.stream().flatMap(group -> group.properties().stream()).toList());
        return this;
    }

    public OutboundElementTemplateBuilder properties(Property ... properties) {
        this.properties.addAll(Arrays.asList(properties));
        return this;
    }

    public OutboundElementTemplateBuilder properties(Collection<Property> properties) {
        this.properties.addAll(properties);
        return this;
    }

    public OutboundElementTemplate build() {
        if (!this.isTypeAssigned()) {
            throw new IllegalStateException("type is not assigned");
        }
        this.verifyUniquePropertyIds();
        return new OutboundElementTemplate(this.id, this.name, this.version, this.documentationRef, this.description, this.appliesTo, new OutboundElementTemplate.ElementType(this.elementType), this.groups, this.properties, this.icon);
    }

    private boolean isTypeAssigned() {
        return this.properties.stream().anyMatch(property -> property.binding.type().equals("zeebe:taskDefinition:type"));
    }

    private void verifyUniquePropertyIds() {
    }
}

