/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.typeadapters;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;

public class PostConstructAdapterFactory
implements TypeAdapterFactory {
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        for (Class<T> t2 = type.getRawType(); t2 != Object.class && t2.getSuperclass() != null; t2 = t2.getSuperclass()) {
            for (Method m4 : t2.getDeclaredMethods()) {
                if (!m4.isAnnotationPresent(PostConstruct.class)) continue;
                m4.setAccessible(true);
                TypeAdapter<T> delegate = gson.getDelegateAdapter(this, type);
                return new PostConstructAdapter<T>(delegate, m4);
            }
        }
        return null;
    }

    static final class PostConstructAdapter<T>
    extends TypeAdapter<T> {
        private final TypeAdapter<T> delegate;
        private final Method method;

        public PostConstructAdapter(TypeAdapter<T> delegate, Method method) {
            this.delegate = delegate;
            this.method = method;
        }

        @Override
        public T read(JsonReader in) throws IOException {
            T result = this.delegate.read(in);
            if (result != null) {
                try {
                    this.method.invoke(result, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError();
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw new RuntimeException(e.getCause());
                }
            }
            return result;
        }

        @Override
        public void write(JsonWriter out, T value) throws IOException {
            this.delegate.write(out, value);
        }
    }
}

