/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.interceptors;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.interceptors.Intercept;
import com.google.gson.interceptors.JsonPostDeserializer;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public final class InterceptorFactory
implements TypeAdapterFactory {
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Intercept intercept = type.getRawType().getAnnotation(Intercept.class);
        if (intercept == null) {
            return null;
        }
        TypeAdapter<T> delegate = gson.getDelegateAdapter(this, type);
        return new InterceptorAdapter<T>(delegate, intercept);
    }

    static class InterceptorAdapter<T>
    extends TypeAdapter<T> {
        private final TypeAdapter<T> delegate;
        private final JsonPostDeserializer<T> postDeserializer;

        public InterceptorAdapter(TypeAdapter<T> delegate, Intercept intercept) {
            try {
                this.delegate = delegate;
                this.postDeserializer = intercept.postDeserialize().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void write(JsonWriter out, T value) throws IOException {
            this.delegate.write(out, value);
        }

        @Override
        public T read(JsonReader in) throws IOException {
            T result = this.delegate.read(in);
            this.postDeserializer.postDeserialize(result);
            return result;
        }
    }
}

