/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.sagemaker.model;

import com.amazonaws.services.sagemakerruntime.model.InvokeEndpointResult;
import io.camunda.connector.aws.ObjectMapperSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public record SageMakerSyncResponse(Object body, String contentType, String customAttributes, String invokedProductionVariant) {
    public SageMakerSyncResponse(InvokeEndpointResult result) {
        this(SageMakerSyncResponse.mapResponseBody(result), result.getContentType(), result.getCustomAttributes(), result.getInvokedProductionVariant());
    }

    private static Object mapResponseBody(InvokeEndpointResult result) {
        if (result.getContentType().equals("application/json")) {
            return SageMakerSyncResponse.parseJsonResponseBody(result.getBody());
        }
        return StandardCharsets.UTF_8.decode(result.getBody()).toString();
    }

    private static Object parseJsonResponseBody(ByteBuffer json) {
        try {
            return ObjectMapperSupplier.getMapperInstance().readValue(json.array(), Object.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading Sagemaker response.", e);
        }
    }
}

