/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.java.util;

import io.camunda.connector.generator.api.GeneratorConfiguration;
import io.camunda.connector.generator.java.annotation.ElementTemplate;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ConfigurationUtil {
    public static GeneratorConfiguration fromAnnotation(ElementTemplate annotation, GeneratorConfiguration override) {
        String templateId = annotation.id();
        if (override.templateId() != null) {
            templateId = override.templateId();
        }
        String templateName = Optional.ofNullable(override.templateName()).orElseGet(annotation::name);
        Integer templateVersion = Optional.ofNullable(override.templateVersion()).orElseGet(annotation::version);
        GeneratorConfiguration.ConnectorMode connectorMode = override.connectorMode();
        Set<GeneratorConfiguration.ConnectorElementType> elementTypes = Arrays.stream(annotation.elementTypes()).map(type -> new GeneratorConfiguration.ConnectorElementType(Arrays.stream(type.appliesTo()).collect(Collectors.toSet()), type.elementType(), type.templateNameOverride().isBlank() ? null : type.templateNameOverride(), type.templateIdOverride().isBlank() ? null : type.templateIdOverride())).collect(Collectors.toSet());
        if (override.elementTypes() != null && !override.elementTypes().isEmpty()) {
            elementTypes = override.elementTypes();
        }
        Map features = Optional.ofNullable(override.features()).orElseGet(Map::of);
        return new GeneratorConfiguration(connectorMode, templateId, templateName, templateVersion, elementTypes, features);
    }
}

