/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.java.processor;

import io.camunda.connector.generator.dsl.DropdownProperty;
import io.camunda.connector.generator.dsl.Property;
import io.camunda.connector.generator.dsl.PropertyBuilder;
import io.camunda.connector.generator.dsl.PropertyCondition;
import io.camunda.connector.generator.dsl.PropertyConstraints;
import io.camunda.connector.generator.java.annotation.TemplateProperty;
import io.camunda.connector.generator.java.processor.FieldProcessor;
import io.camunda.connector.generator.java.util.TemplateGenerationContext;
import java.lang.reflect.Field;
import java.util.Arrays;

public class TemplatePropertyFieldProcessor
implements FieldProcessor {
    @Override
    public void process(Field field2, PropertyBuilder builder, TemplateGenerationContext context) {
        TemplateProperty annotation = field2.getAnnotation(TemplateProperty.class);
        if (annotation == null) {
            return;
        }
        builder.optional(FieldProcessor.isOptional(field2));
        if (!(builder instanceof DropdownProperty.DropdownPropertyBuilder)) {
            if (annotation.feel() == Property.FeelMode.system_default) {
                builder.feel(this.determineDefaultFeelModeBasedOnContext(context));
            } else {
                builder.feel(annotation.feel());
            }
        }
        if (!annotation.label().isBlank()) {
            builder.label(annotation.label());
        }
        if (!annotation.description().isBlank()) {
            builder.description(annotation.description());
        }
        if (!annotation.defaultValue().isBlank()) {
            String value = annotation.defaultValue();
            switch (annotation.defaultValueType()) {
                case Boolean: {
                    builder.value(Boolean.parseBoolean(value));
                    break;
                }
                case String: {
                    builder.value(value);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)annotation.defaultValueType()));
                }
            }
        }
        if (!annotation.group().isBlank()) {
            builder.group(annotation.group());
        }
        builder.condition(this.buildCondition(annotation));
        builder.constraints(this.buildConstraints(annotation));
    }

    private Property.FeelMode determineDefaultFeelModeBasedOnContext(TemplateGenerationContext context) {
        return context instanceof TemplateGenerationContext.Inbound ? Property.FeelMode.disabled : Property.FeelMode.optional;
    }

    private PropertyCondition buildCondition(TemplateProperty propertyAnnotation) {
        TemplateProperty.PropertyCondition conditionAnnotation = propertyAnnotation.condition();
        if (conditionAnnotation.property().isBlank() && conditionAnnotation.allMatch().length == 0) {
            return null;
        }
        TemplatePropertyFieldProcessor.validateCondition(conditionAnnotation.property(), conditionAnnotation.equals(), conditionAnnotation.oneOf(), conditionAnnotation.allMatch());
        return TemplatePropertyFieldProcessor.transformToCondition(conditionAnnotation);
    }

    public static PropertyCondition transformToCondition(TemplateProperty.PropertyCondition conditionAnnotation) {
        if (!conditionAnnotation.equals().isBlank()) {
            return new PropertyCondition.Equals(conditionAnnotation.property(), conditionAnnotation.equals());
        }
        if (conditionAnnotation.oneOf().length > 0) {
            return new PropertyCondition.OneOf(conditionAnnotation.property(), Arrays.asList(conditionAnnotation.oneOf()));
        }
        if (conditionAnnotation.allMatch().length > 0) {
            return new PropertyCondition.AllMatch(Arrays.stream(conditionAnnotation.allMatch()).map(TemplatePropertyFieldProcessor::transformToNestedCondition).toList());
        }
        return new PropertyCondition.IsActive(conditionAnnotation.property(), conditionAnnotation.isActive());
    }

    public static PropertyCondition transformToNestedCondition(TemplateProperty.NestedPropertyCondition conditionAnnotation) {
        TemplatePropertyFieldProcessor.validateCondition(conditionAnnotation.property(), conditionAnnotation.equals(), conditionAnnotation.oneOf(), new TemplateProperty.NestedPropertyCondition[0]);
        if (!conditionAnnotation.equals().isBlank()) {
            return new PropertyCondition.Equals(conditionAnnotation.property(), conditionAnnotation.equals());
        }
        if (conditionAnnotation.oneOf().length > 0) {
            return new PropertyCondition.OneOf(conditionAnnotation.property(), Arrays.asList(conditionAnnotation.oneOf()));
        }
        return new PropertyCondition.IsActive(conditionAnnotation.property(), conditionAnnotation.isActive());
    }

    private static void validateCondition(String property, String equals, String[] oneOf, TemplateProperty.NestedPropertyCondition[] allMatch) {
        boolean allMatchSet;
        boolean equalsSet = !equals.isBlank();
        boolean oneOfSet = oneOf != null && oneOf.length > 0;
        boolean bl = allMatchSet = allMatch != null && allMatch.length > 0;
        if (equalsSet && oneOfSet || equalsSet && allMatchSet || oneOfSet && allMatchSet) {
            throw new IllegalStateException("Condition must have only one of 'equals', 'oneOf', 'isActive', or 'allMatch' set");
        }
        if (equalsSet && property.isBlank()) {
            throw new IllegalStateException("Condition 'equals' must have 'property' set");
        }
        if (oneOfSet && property.isBlank()) {
            throw new IllegalStateException("Condition 'oneOf' must have 'property' set");
        }
        if (allMatchSet && !property.isBlank()) {
            throw new IllegalStateException("Condition 'allMatch' must not have 'property' set");
        }
        if (!equalsSet && !oneOfSet && !allMatchSet && property.isBlank()) {
            throw new IllegalStateException("Condition 'isActive' must have 'property' set");
        }
    }

    private PropertyConstraints buildConstraints(TemplateProperty propertyAnnotation) {
        TemplateProperty.PropertyConstraints constraintsAnnotation = propertyAnnotation.constraints();
        if (!constraintsAnnotation.notEmpty() && constraintsAnnotation.maxLength() == Integer.MAX_VALUE && constraintsAnnotation.minLength() == Integer.MIN_VALUE && constraintsAnnotation.pattern().value().isBlank()) {
            return null;
        }
        PropertyConstraints.PropertyConstraintsBuilder builder = PropertyConstraints.builder();
        if (constraintsAnnotation.notEmpty()) {
            builder.notEmpty(true);
        }
        if (constraintsAnnotation.maxLength() != Integer.MAX_VALUE) {
            builder.maxLength(constraintsAnnotation.maxLength());
        }
        if (constraintsAnnotation.minLength() != Integer.MIN_VALUE) {
            builder.minLength(constraintsAnnotation.minLength());
        }
        if (!constraintsAnnotation.pattern().value().isBlank()) {
            if (!constraintsAnnotation.notEmpty() && propertyAnnotation.optional()) {
                builder.notEmpty(false);
            }
            builder.pattern(new PropertyConstraints.Pattern(constraintsAnnotation.pattern().value(), constraintsAnnotation.pattern().message()));
        }
        return builder.build();
    }
}

