/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl;

import connector.com.fasterxml.jackson.annotation.JsonIgnore;
import connector.com.fasterxml.jackson.annotation.JsonInclude;
import connector.com.fasterxml.jackson.annotation.JsonProperty;
import connector.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.connector.generator.dsl.BpmnType;
import io.camunda.connector.generator.dsl.ElementTemplateBuilder;
import io.camunda.connector.generator.dsl.ElementTemplateCategory;
import io.camunda.connector.generator.dsl.ElementTemplateIcon;
import io.camunda.connector.generator.dsl.Property;
import io.camunda.connector.generator.dsl.PropertyGroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonPropertyOrder(value={"$schema", "name", "id", "description", "documentationRef", "version", "category", "appliesTo", "elementType", "groups", "properties"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record ElementTemplate(String id, String name, int version, String documentationRef, String description, Set<String> appliesTo, ElementTypeWrapper elementType, List<PropertyGroup> groups, List<Property> properties, ElementTemplateIcon icon) {
    static final String SCHEMA_FIELD_NAME = "$schema";
    static final String SCHEMA_URL = "https://unpkg.com/@camunda/zeebe-element-templates-json-schema/resources/schema.json";

    public ElementTemplate {
        ArrayList<Object> errors = new ArrayList<Object>();
        if (id == null) {
            errors.add("id is required");
        }
        if (name == null) {
            errors.add("name is required");
        }
        if (version < 0) {
            errors.add("version cannot be negative");
        }
        if (appliesTo == null || appliesTo.isEmpty() || appliesTo.stream().allMatch(String::isBlank)) {
            errors.add("appliesTo must be defined");
        }
        if (elementType == null || elementType.value == null || elementType.value.isBlank()) {
            errors.add("elementType must be defined");
        }
        if (groups == null) {
            errors.add("groups is required");
        }
        if (properties == null) {
            errors.add("properties is required");
        } else {
            HashSet<String> propIdOccurrences = new HashSet<String>();
            for (Property property : properties) {
                if (property.id == null) continue;
                if (propIdOccurrences.contains(property.id)) {
                    errors.add("duplicate property " + property.id);
                }
                propIdOccurrences.add(property.id);
            }
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(String.join((CharSequence)", ", errors));
        }
        if (icon != null && !icon.contents().matches("^(data):.*")) {
            throw new IllegalArgumentException("icon contents must be base64 encoded");
        }
    }

    public static ElementTemplateBuilder builderForOutbound() {
        return ElementTemplateBuilder.createOutbound();
    }

    public static ElementTemplateBuilder builderForInbound() {
        return ElementTemplateBuilder.createInbound();
    }

    @JsonProperty
    public ElementTemplateCategory category() {
        return ElementTemplateCategory.CONNECTORS;
    }

    @JsonProperty(value="$schema")
    public String schema() {
        return SCHEMA_URL;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ElementTypeWrapper(String value, String eventDefinition, @JsonIgnore BpmnType originalType) {
        public static ElementTypeWrapper from(BpmnType value) {
            Set<BpmnType> haveEventDefinition = Set.of(BpmnType.INTERMEDIATE_CATCH_EVENT, BpmnType.INTERMEDIATE_THROW_EVENT, BpmnType.MESSAGE_START_EVENT, BpmnType.MESSAGE_END_EVENT, BpmnType.BOUNDARY_EVENT);
            String messageEventDefinition = "bpmn:MessageEventDefinition";
            return new ElementTypeWrapper(value.getName(), haveEventDefinition.contains((Object)value) ? messageEventDefinition : null, value);
        }
    }
}

