/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.aws.model.impl;

import connector.com.fasterxml.jackson.annotation.JsonSubTypes;
import connector.com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.camunda.connector.generator.java.annotation.TemplateDiscriminatorProperty;
import io.camunda.connector.generator.java.annotation.TemplateProperty;
import io.camunda.connector.generator.java.annotation.TemplateSubType;
import jakarta.validation.constraints.NotBlank;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=AwsStaticCredentialsAuthentication.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AwsStaticCredentialsAuthentication.class, name="credentials"), @JsonSubTypes.Type(value=AwsDefaultCredentialsChainAuthentication.class, name="defaultCredentialsChain")})
@TemplateDiscriminatorProperty(label="Authentication", group="authentication", name="type", defaultValue="credentials", description="Specify AWS authentication strategy. Learn more at the <a href=\"https://docs.camunda.io/docs/components/connectors/out-of-the-box-connectors/aws-lambda/#aws-authentication-types\" target=\"_blank\">documentation page</a>")
public sealed interface AwsAuthentication {

    @TemplateSubType(id="defaultCredentialsChain", label="Default Credentials Chain (Hybrid/Self-Managed only)")
    public record AwsDefaultCredentialsChainAuthentication() implements AwsAuthentication
    {
    }

    @TemplateSubType(id="credentials", label="Credentials")
    public record AwsStaticCredentialsAuthentication(@TemplateProperty(group="authentication", label="Access key", description="Provide an IAM access key tailored to a user, equipped with the necessary permissions") @NotBlank String accessKey, @TemplateProperty(group="authentication", label="Secret key", description="Provide a secret key of a user with permissions to invoke specified AWS Lambda function") @NotBlank String secretKey) implements AwsAuthentication
    {
        @Override
        public String toString() {
            return "AwsStaticCredentialsAuthentication{accessKey=[REDACTED], secretKey=[REDACTED]}";
        }
    }
}

