/*
 * Decompiled with CFR 0.152.
 */
package connector.com.fasterxml.jackson.module.scala.deser;

import connector.com.fasterxml.jackson.core.JsonParser;
import connector.com.fasterxml.jackson.core.JsonToken;
import connector.com.fasterxml.jackson.databind.BeanProperty;
import connector.com.fasterxml.jackson.databind.DeserializationConfig;
import connector.com.fasterxml.jackson.databind.DeserializationContext;
import connector.com.fasterxml.jackson.databind.JavaType;
import connector.com.fasterxml.jackson.databind.JsonDeserializer;
import connector.com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import connector.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import connector.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import connector.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import connector.com.fasterxml.jackson.module.scala.deser.TupleDeserializer$;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public class TupleDeserializer
extends StdDeserializer<Product>
implements ContextualDeserializer {
    private final JavaType javaType;
    private final DeserializationConfig config;
    private final Seq<JsonDeserializer<Object>> valueDeserializers;
    private final Seq<TypeDeserializer> typeDeserializers;
    private final Class cls;
    private final Constructor[] ctors;
    private final Constructor ctor;

    public static Seq<JsonDeserializer<Object>> $lessinit$greater$default$3() {
        return TupleDeserializer$.MODULE$.$lessinit$greater$default$3();
    }

    public static Seq<TypeDeserializer> $lessinit$greater$default$4() {
        return TupleDeserializer$.MODULE$.$lessinit$greater$default$4();
    }

    public TupleDeserializer(JavaType javaType, DeserializationConfig config, Seq<JsonDeserializer<Object>> valueDeserializers, Seq<TypeDeserializer> typeDeserializers) {
        this.javaType = javaType;
        this.config = config;
        this.valueDeserializers = valueDeserializers;
        this.typeDeserializers = typeDeserializers;
        super(Product.class);
        this.cls = javaType.getRawClass();
        this.ctors = this.cls().getConstructors();
        if (this.ctors().length != 1) {
            throw new IllegalStateException("Tuple should have exactly one constructor");
        }
        Object object = Predef$.MODULE$.refArrayOps(this.ctors());
        this.ctor = (Constructor)ArrayOps$.MODULE$.head$extension(object);
    }

    public Class<?> cls() {
        return this.cls;
    }

    public Constructor<?>[] ctors() {
        return this.ctors;
    }

    public Constructor<?> ctor() {
        return this.ctor;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        Object paramTypes = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.javaType.containedTypeCount()).map((Function1<Object, JavaType> & Serializable)i -> this.$anonfun$1(BoxesRunTime.unboxToInt(i)));
        IndexedSeq paramDesers = (IndexedSeq)paramTypes.map((Function1<JavaType, JsonDeserializer> & Serializable)_$1 -> ctxt.findContextualValueDeserializer((JavaType)_$1, property));
        BeanDeserializerFactory factory = BeanDeserializerFactory.instance;
        Seq typeDesers = property != null ? (Seq)paramTypes.map((Function1<JavaType, TypeDeserializer> & Serializable)_$2 -> factory.findPropertyTypeDeserializer(ctxt.getConfig(), (JavaType)_$2, property.getMember())) : (Seq)paramTypes.map((Function1<JavaType, TypeDeserializer> & Serializable)_$3 -> factory.findTypeDeserializer(this.config, (JavaType)_$3));
        return new TupleDeserializer(this.javaType, this.config, paramDesers, typeDesers);
    }

    @Override
    public Product deserialize(JsonParser jp, DeserializationContext ctxt) {
        if (jp.isExpectedStartArrayToken()) {
            JsonToken t;
            Seq params = (Seq)((IterableOps)this.valueDeserializers.zip(this.typeDeserializers)).map((Function1<Tuple2, Object> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    JsonDeserializer deser = (JsonDeserializer)tuple2._1();
                    TypeDeserializer typeDeser = (TypeDeserializer)tuple2._2();
                    jp.nextToken();
                    if (typeDeser == null) {
                        return deser.deserialize(jp, ctxt);
                    }
                    return deser.deserializeWithType(jp, ctxt, typeDeser);
                }
                throw new MatchError(tuple2);
            });
            JsonToken jsonToken = t = jp.nextToken();
            JsonToken jsonToken2 = JsonToken.END_ARRAY;
            if (jsonToken == null ? jsonToken2 != null : !((Object)((Object)jsonToken)).equals((Object)jsonToken2)) {
                ctxt.wrongTokenException(jp, ctxt.getContextualType(), JsonToken.END_ARRAY, "expected closing END_ARRAY after deserialized value");
                return null;
            }
            return (Product)this.ctor().newInstance((Object[])Arrays$.MODULE$.seqToArray(params, Object.class));
        }
        return (Product)ctxt.handleUnexpectedToken(this.javaType.getRawClass(), jp);
    }

    private final /* synthetic */ JavaType $anonfun$1(int i) {
        return this.javaType.containedType(i);
    }
}

