/*
 * Decompiled with CFR 0.152.
 */
package connector.com.fasterxml.jackson.datatype.jsr310;

import connector.com.fasterxml.jackson.core.util.JacksonFeature;
import connector.com.fasterxml.jackson.core.util.JacksonFeatureSet;
import connector.com.fasterxml.jackson.databind.BeanDescription;
import connector.com.fasterxml.jackson.databind.DeserializationConfig;
import connector.com.fasterxml.jackson.databind.JavaType;
import connector.com.fasterxml.jackson.databind.Module;
import connector.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import connector.com.fasterxml.jackson.databind.deser.ValueInstantiators;
import connector.com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import connector.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import connector.com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import connector.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import connector.com.fasterxml.jackson.databind.module.SimpleDeserializers;
import connector.com.fasterxml.jackson.databind.module.SimpleKeyDeserializers;
import connector.com.fasterxml.jackson.databind.module.SimpleModule;
import connector.com.fasterxml.jackson.databind.module.SimpleSerializers;
import connector.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import connector.com.fasterxml.jackson.datatype.jsr310.JavaTimeFeature;
import connector.com.fasterxml.jackson.datatype.jsr310.PackageVersion;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.DurationDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.JSR310StringParsableDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.JavaTimeDeserializerModifier;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.MonthDayDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.OffsetTimeDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.YearDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.YearMonthDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.key.DurationKeyDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.key.InstantKeyDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.key.LocalDateKeyDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.key.LocalDateTimeKeyDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.key.LocalTimeKeyDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.key.MonthDayKeyDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.key.OffsetDateTimeKeyDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.key.OffsetTimeKeyDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.key.PeriodKeyDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.key.YearKeyDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.key.YearMonthKeyDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.key.ZoneIdKeyDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.key.ZoneOffsetKeyDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.key.ZonedDateTimeKeyDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.ser.DurationSerializer;
import connector.com.fasterxml.jackson.datatype.jsr310.ser.InstantSerializer;
import connector.com.fasterxml.jackson.datatype.jsr310.ser.JavaTimeSerializerModifier;
import connector.com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import connector.com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import connector.com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import connector.com.fasterxml.jackson.datatype.jsr310.ser.MonthDaySerializer;
import connector.com.fasterxml.jackson.datatype.jsr310.ser.OffsetDateTimeSerializer;
import connector.com.fasterxml.jackson.datatype.jsr310.ser.OffsetTimeSerializer;
import connector.com.fasterxml.jackson.datatype.jsr310.ser.YearMonthSerializer;
import connector.com.fasterxml.jackson.datatype.jsr310.ser.YearSerializer;
import connector.com.fasterxml.jackson.datatype.jsr310.ser.ZoneIdSerializer;
import connector.com.fasterxml.jackson.datatype.jsr310.ser.ZonedDateTimeSerializer;
import connector.com.fasterxml.jackson.datatype.jsr310.ser.key.ZonedDateTimeKeySerializer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class JavaTimeModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private JacksonFeatureSet<JavaTimeFeature> _features = JacksonFeatureSet.fromDefaults((JacksonFeature[])JavaTimeFeature.values());

    public JavaTimeModule() {
        super(PackageVersion.VERSION);
    }

    public JavaTimeModule enable(JavaTimeFeature f) {
        this._features = this._features.with(f);
        return this;
    }

    public JavaTimeModule disable(JavaTimeFeature f) {
        this._features = this._features.without(f);
        return this;
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        SimpleDeserializers desers = new SimpleDeserializers();
        desers.addDeserializer(Instant.class, InstantDeserializer.INSTANT.withFeatures(this._features));
        desers.addDeserializer(OffsetDateTime.class, InstantDeserializer.OFFSET_DATE_TIME.withFeatures(this._features));
        desers.addDeserializer(ZonedDateTime.class, InstantDeserializer.ZONED_DATE_TIME.withFeatures(this._features));
        desers.addDeserializer(Duration.class, DurationDeserializer.INSTANCE);
        desers.addDeserializer(LocalDateTime.class, LocalDateTimeDeserializer.INSTANCE);
        desers.addDeserializer(LocalDate.class, LocalDateDeserializer.INSTANCE);
        desers.addDeserializer(LocalTime.class, LocalTimeDeserializer.INSTANCE);
        desers.addDeserializer(MonthDay.class, MonthDayDeserializer.INSTANCE);
        desers.addDeserializer(OffsetTime.class, OffsetTimeDeserializer.INSTANCE);
        desers.addDeserializer(Period.class, JSR310StringParsableDeserializer.PERIOD);
        desers.addDeserializer(Year.class, YearDeserializer.INSTANCE);
        desers.addDeserializer(YearMonth.class, YearMonthDeserializer.INSTANCE);
        desers.addDeserializer(ZoneId.class, JSR310StringParsableDeserializer.ZONE_ID);
        desers.addDeserializer(ZoneOffset.class, JSR310StringParsableDeserializer.ZONE_OFFSET);
        context.addDeserializers(desers);
        boolean oneBasedMonthEnabled = this._features.isEnabled(JavaTimeFeature.ONE_BASED_MONTHS);
        context.addBeanDeserializerModifier(new JavaTimeDeserializerModifier(oneBasedMonthEnabled));
        context.addBeanSerializerModifier(new JavaTimeSerializerModifier(oneBasedMonthEnabled));
        if (this._deserializers != null) {
            context.addDeserializers(this._deserializers);
        }
        SimpleSerializers sers = new SimpleSerializers();
        sers.addSerializer(Duration.class, DurationSerializer.INSTANCE);
        sers.addSerializer(Instant.class, InstantSerializer.INSTANCE);
        sers.addSerializer(LocalDateTime.class, LocalDateTimeSerializer.INSTANCE);
        sers.addSerializer(LocalDate.class, LocalDateSerializer.INSTANCE);
        sers.addSerializer(LocalTime.class, LocalTimeSerializer.INSTANCE);
        sers.addSerializer(MonthDay.class, MonthDaySerializer.INSTANCE);
        sers.addSerializer(OffsetDateTime.class, OffsetDateTimeSerializer.INSTANCE);
        sers.addSerializer(OffsetTime.class, OffsetTimeSerializer.INSTANCE);
        sers.addSerializer(Period.class, new ToStringSerializer(Period.class));
        sers.addSerializer(Year.class, YearSerializer.INSTANCE);
        sers.addSerializer(YearMonth.class, YearMonthSerializer.INSTANCE);
        sers.addSerializer(ZonedDateTime.class, ZonedDateTimeSerializer.INSTANCE);
        sers.addSerializer(ZoneId.class, new ZoneIdSerializer());
        sers.addSerializer(ZoneOffset.class, new ToStringSerializer(ZoneOffset.class));
        context.addSerializers(sers);
        if (this._serializers != null) {
            context.addSerializers(this._serializers);
        }
        SimpleSerializers keySers = new SimpleSerializers();
        keySers.addSerializer(ZonedDateTime.class, ZonedDateTimeKeySerializer.INSTANCE);
        context.addKeySerializers(keySers);
        if (this._keySerializers != null) {
            context.addKeySerializers(this._keySerializers);
        }
        SimpleKeyDeserializers keyDesers = new SimpleKeyDeserializers();
        keyDesers.addDeserializer(Duration.class, DurationKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(Instant.class, InstantKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(LocalDateTime.class, LocalDateTimeKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(LocalDate.class, LocalDateKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(LocalTime.class, LocalTimeKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(MonthDay.class, MonthDayKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(OffsetDateTime.class, OffsetDateTimeKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(OffsetTime.class, OffsetTimeKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(Period.class, PeriodKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(Year.class, YearKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(YearMonth.class, YearMonthKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(ZonedDateTime.class, ZonedDateTimeKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(ZoneId.class, ZoneIdKeyDeserializer.INSTANCE);
        keyDesers.addDeserializer(ZoneOffset.class, ZoneOffsetKeyDeserializer.INSTANCE);
        context.addKeyDeserializers(keyDesers);
        if (this._keyDeserializers != null) {
            context.addKeyDeserializers(this._keyDeserializers);
        }
        context.addValueInstantiators(new ValueInstantiators.Base(){

            @Override
            public ValueInstantiator findValueInstantiator(DeserializationConfig config, BeanDescription beanDesc, ValueInstantiator defaultInstantiator) {
                JavaType type = beanDesc.getType();
                Class<?> raw = type.getRawClass();
                if (ZoneId.class.isAssignableFrom(raw) && defaultInstantiator instanceof StdValueInstantiator) {
                    AnnotatedMethod factory;
                    StdValueInstantiator inst = (StdValueInstantiator)defaultInstantiator;
                    AnnotatedClass ac = raw == ZoneId.class ? beanDesc.getClassInfo() : AnnotatedClassResolver.resolve(config, config.constructType(ZoneId.class), config);
                    if (!inst.canCreateFromString() && (factory = JavaTimeModule.this._findFactory(ac, "of", String.class)) != null) {
                        inst.configureFromStringCreator(factory);
                    }
                }
                return defaultInstantiator;
            }
        });
    }

    protected AnnotatedMethod _findFactory(AnnotatedClass cls, String name, Class<?> ... argTypes) {
        int argCount = argTypes.length;
        for (AnnotatedMethod method : cls.getFactoryMethods()) {
            if (!name.equals(method.getName()) || method.getParameterCount() != argCount) continue;
            for (int i = 0; i < argCount; ++i) {
                Class<?> argType = method.getParameter(i).getRawType();
                if (argType.isAssignableFrom(argTypes[i])) continue;
            }
            return method;
        }
        return null;
    }
}

