/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakerruntime;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sagemakerruntime.AmazonSageMakerRuntimeAsync;
import com.amazonaws.services.sagemakerruntime.AmazonSageMakerRuntimeAsyncClientBuilder;
import com.amazonaws.services.sagemakerruntime.AmazonSageMakerRuntimeClient;
import com.amazonaws.services.sagemakerruntime.model.InvokeEndpointAsyncRequest;
import com.amazonaws.services.sagemakerruntime.model.InvokeEndpointAsyncResult;
import com.amazonaws.services.sagemakerruntime.model.InvokeEndpointRequest;
import com.amazonaws.services.sagemakerruntime.model.InvokeEndpointResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonSageMakerRuntimeAsyncClient
extends AmazonSageMakerRuntimeClient
implements AmazonSageMakerRuntimeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonSageMakerRuntimeAsyncClientBuilder asyncBuilder() {
        return AmazonSageMakerRuntimeAsyncClientBuilder.standard();
    }

    AmazonSageMakerRuntimeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonSageMakerRuntimeAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super(asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<InvokeEndpointResult> invokeEndpointAsync(InvokeEndpointRequest request) {
        return this.invokeEndpointAsync(request, null);
    }

    @Override
    public Future<InvokeEndpointResult> invokeEndpointAsync(InvokeEndpointRequest request, final AsyncHandler<InvokeEndpointRequest, InvokeEndpointResult> asyncHandler) {
        final InvokeEndpointRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<InvokeEndpointResult>(){

            @Override
            public InvokeEndpointResult call() throws Exception {
                InvokeEndpointResult result = null;
                try {
                    result = AmazonSageMakerRuntimeAsyncClient.this.executeInvokeEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InvokeEndpointAsyncResult> invokeEndpointAsyncAsync(InvokeEndpointAsyncRequest request) {
        return this.invokeEndpointAsyncAsync(request, null);
    }

    @Override
    public Future<InvokeEndpointAsyncResult> invokeEndpointAsyncAsync(InvokeEndpointAsyncRequest request, final AsyncHandler<InvokeEndpointAsyncRequest, InvokeEndpointAsyncResult> asyncHandler) {
        final InvokeEndpointAsyncRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<InvokeEndpointAsyncResult>(){

            @Override
            public InvokeEndpointAsyncResult call() throws Exception {
                InvokeEndpointAsyncResult result = null;
                try {
                    result = AmazonSageMakerRuntimeAsyncClient.this.executeInvokeEndpointAsync(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

