/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.sagemaker.model.DescribeImageResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import connector.com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class ImageDeleted {
    ImageDeleted() {
    }

    static class IsValidationExceptionMatcher
    extends WaiterAcceptor<DescribeImageResult> {
        IsValidationExceptionMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "ValidationException".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }
    }

    static class IsDELETE_FAILEDMatcher
    extends WaiterAcceptor<DescribeImageResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsDELETE_FAILEDMatcher() {
        }

        @Override
        public boolean matches(DescribeImageResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"DELETE_FAILED\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("ImageStatus");
        }
    }

    static class IsResourceNotFoundExceptionMatcher
    extends WaiterAcceptor<DescribeImageResult> {
        IsResourceNotFoundExceptionMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "ResourceNotFoundException".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }
    }
}

