/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.UiTemplateInfo;

@SdkInternalApi
public class UiTemplateInfoMarshaller {
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Url").build();
    private static final MarshallingInfo<String> CONTENTSHA256_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentSha256").build();
    private static final UiTemplateInfoMarshaller instance = new UiTemplateInfoMarshaller();

    public static UiTemplateInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(UiTemplateInfo uiTemplateInfo, ProtocolMarshaller protocolMarshaller) {
        if (uiTemplateInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(uiTemplateInfo.getUrl(), URL_BINDING);
            protocolMarshaller.marshall(uiTemplateInfo.getContentSha256(), CONTENTSHA256_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

