/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.USD;

@SdkInternalApi
public class USDMarshaller {
    private static final MarshallingInfo<Integer> DOLLARS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dollars").build();
    private static final MarshallingInfo<Integer> CENTS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Cents").build();
    private static final MarshallingInfo<Integer> TENTHFRACTIONSOFACENT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TenthFractionsOfACent").build();
    private static final USDMarshaller instance = new USDMarshaller();

    public static USDMarshaller getInstance() {
        return instance;
    }

    public void marshall(USD uSD, ProtocolMarshaller protocolMarshaller) {
        if (uSD == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(uSD.getDollars(), DOLLARS_BINDING);
            protocolMarshaller.marshall(uSD.getCents(), CENTS_BINDING);
            protocolMarshaller.marshall(uSD.getTenthFractionsOfACent(), TENTHFRACTIONSOFACENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

