/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.TrainingJobDefinition;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class TrainingJobDefinitionMarshaller {
    private static final MarshallingInfo<String> TRAININGINPUTMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingInputMode").build();
    private static final MarshallingInfo<Map> HYPERPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HyperParameters").build();
    private static final MarshallingInfo<List> INPUTDATACONFIG_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataConfig").build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTDATACONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputDataConfig").build();
    private static final MarshallingInfo<StructuredPojo> RESOURCECONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceConfig").build();
    private static final MarshallingInfo<StructuredPojo> STOPPINGCONDITION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StoppingCondition").build();
    private static final TrainingJobDefinitionMarshaller instance = new TrainingJobDefinitionMarshaller();

    public static TrainingJobDefinitionMarshaller getInstance() {
        return instance;
    }

    public void marshall(TrainingJobDefinition trainingJobDefinition, ProtocolMarshaller protocolMarshaller) {
        if (trainingJobDefinition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(trainingJobDefinition.getTrainingInputMode(), TRAININGINPUTMODE_BINDING);
            protocolMarshaller.marshall(trainingJobDefinition.getHyperParameters(), HYPERPARAMETERS_BINDING);
            protocolMarshaller.marshall(trainingJobDefinition.getInputDataConfig(), INPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall(trainingJobDefinition.getOutputDataConfig(), OUTPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall(trainingJobDefinition.getResourceConfig(), RESOURCECONFIG_BINDING);
            protocolMarshaller.marshall(trainingJobDefinition.getStoppingCondition(), STOPPINGCONDITION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

