/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.TimeSeriesConfig;
import java.util.List;

@SdkInternalApi
public class TimeSeriesConfigMarshaller {
    private static final MarshallingInfo<String> TARGETATTRIBUTENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetAttributeName").build();
    private static final MarshallingInfo<String> TIMESTAMPATTRIBUTENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimestampAttributeName").build();
    private static final MarshallingInfo<String> ITEMIDENTIFIERATTRIBUTENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ItemIdentifierAttributeName").build();
    private static final MarshallingInfo<List> GROUPINGATTRIBUTENAMES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GroupingAttributeNames").build();
    private static final TimeSeriesConfigMarshaller instance = new TimeSeriesConfigMarshaller();

    public static TimeSeriesConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(TimeSeriesConfig timeSeriesConfig, ProtocolMarshaller protocolMarshaller) {
        if (timeSeriesConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(timeSeriesConfig.getTargetAttributeName(), TARGETATTRIBUTENAME_BINDING);
            protocolMarshaller.marshall(timeSeriesConfig.getTimestampAttributeName(), TIMESTAMPATTRIBUTENAME_BINDING);
            protocolMarshaller.marshall(timeSeriesConfig.getItemIdentifierAttributeName(), ITEMIDENTIFIERATTRIBUTENAME_BINDING);
            protocolMarshaller.marshall(timeSeriesConfig.getGroupingAttributeNames(), GROUPINGATTRIBUTENAMES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

