/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.TensorBoardOutputConfig;

@SdkInternalApi
public class TensorBoardOutputConfigMarshaller {
    private static final MarshallingInfo<String> LOCALPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalPath").build();
    private static final MarshallingInfo<String> S3OUTPUTPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3OutputPath").build();
    private static final TensorBoardOutputConfigMarshaller instance = new TensorBoardOutputConfigMarshaller();

    public static TensorBoardOutputConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(TensorBoardOutputConfig tensorBoardOutputConfig, ProtocolMarshaller protocolMarshaller) {
        if (tensorBoardOutputConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(tensorBoardOutputConfig.getLocalPath(), LOCALPATH_BINDING);
            protocolMarshaller.marshall(tensorBoardOutputConfig.getS3OutputPath(), S3OUTPUTPATH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

