/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.ShuffleConfig;

@SdkInternalApi
public class ShuffleConfigMarshaller {
    private static final MarshallingInfo<Long> SEED_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Seed").build();
    private static final ShuffleConfigMarshaller instance = new ShuffleConfigMarshaller();

    public static ShuffleConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(ShuffleConfig shuffleConfig, ProtocolMarshaller protocolMarshaller) {
        if (shuffleConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(shuffleConfig.getSeed(), SEED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

