/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.services.sagemaker.model.S3StorageConfig;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import connector.com.fasterxml.jackson.core.JsonToken;

public class S3StorageConfigJsonUnmarshaller
implements Unmarshaller<S3StorageConfig, JsonUnmarshallerContext> {
    private static S3StorageConfigJsonUnmarshaller instance;

    @Override
    public S3StorageConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3StorageConfig s3StorageConfig = new S3StorageConfig();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3Uri", targetDepth)) {
                    context.nextToken();
                    s3StorageConfig.setS3Uri(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("KmsKeyId", targetDepth)) {
                    context.nextToken();
                    s3StorageConfig.setKmsKeyId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ResolvedOutputS3Uri", targetDepth)) {
                    context.nextToken();
                    s3StorageConfig.setResolvedOutputS3Uri(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3StorageConfig;
    }

    public static S3StorageConfigJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3StorageConfigJsonUnmarshaller();
        }
        return instance;
    }
}

