/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.S3ModelDataSource;

@SdkInternalApi
public class S3ModelDataSourceMarshaller {
    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Uri").build();
    private static final MarshallingInfo<String> S3DATATYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DataType").build();
    private static final MarshallingInfo<String> COMPRESSIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompressionType").build();
    private static final MarshallingInfo<StructuredPojo> MODELACCESSCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelAccessConfig").build();
    private static final S3ModelDataSourceMarshaller instance = new S3ModelDataSourceMarshaller();

    public static S3ModelDataSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ModelDataSource s3ModelDataSource, ProtocolMarshaller protocolMarshaller) {
        if (s3ModelDataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3ModelDataSource.getS3Uri(), S3URI_BINDING);
            protocolMarshaller.marshall(s3ModelDataSource.getS3DataType(), S3DATATYPE_BINDING);
            protocolMarshaller.marshall(s3ModelDataSource.getCompressionType(), COMPRESSIONTYPE_BINDING);
            protocolMarshaller.marshall(s3ModelDataSource.getModelAccessConfig(), MODELACCESSCONFIG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

