/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.ResourceSpec;

@SdkInternalApi
public class ResourceSpecMarshaller {
    private static final MarshallingInfo<String> SAGEMAKERIMAGEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SageMakerImageArn").build();
    private static final MarshallingInfo<String> SAGEMAKERIMAGEVERSIONARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SageMakerImageVersionArn").build();
    private static final MarshallingInfo<String> SAGEMAKERIMAGEVERSIONALIAS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SageMakerImageVersionAlias").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").build();
    private static final MarshallingInfo<String> LIFECYCLECONFIGARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LifecycleConfigArn").build();
    private static final ResourceSpecMarshaller instance = new ResourceSpecMarshaller();

    public static ResourceSpecMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceSpec resourceSpec, ProtocolMarshaller protocolMarshaller) {
        if (resourceSpec == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(resourceSpec.getSageMakerImageArn(), SAGEMAKERIMAGEARN_BINDING);
            protocolMarshaller.marshall(resourceSpec.getSageMakerImageVersionArn(), SAGEMAKERIMAGEVERSIONARN_BINDING);
            protocolMarshaller.marshall(resourceSpec.getSageMakerImageVersionAlias(), SAGEMAKERIMAGEVERSIONALIAS_BINDING);
            protocolMarshaller.marshall(resourceSpec.getInstanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall(resourceSpec.getLifecycleConfigArn(), LIFECYCLECONFIGARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

