/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.ProfilerRuleConfiguration;
import java.util.Map;

@SdkInternalApi
public class ProfilerRuleConfigurationMarshaller {
    private static final MarshallingInfo<String> RULECONFIGURATIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleConfigurationName").build();
    private static final MarshallingInfo<String> LOCALPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalPath").build();
    private static final MarshallingInfo<String> S3OUTPUTPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3OutputPath").build();
    private static final MarshallingInfo<String> RULEEVALUATORIMAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleEvaluatorImage").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").build();
    private static final MarshallingInfo<Integer> VOLUMESIZEINGB_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeSizeInGB").build();
    private static final MarshallingInfo<Map> RULEPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleParameters").build();
    private static final ProfilerRuleConfigurationMarshaller instance = new ProfilerRuleConfigurationMarshaller();

    public static ProfilerRuleConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProfilerRuleConfiguration profilerRuleConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (profilerRuleConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(profilerRuleConfiguration.getRuleConfigurationName(), RULECONFIGURATIONNAME_BINDING);
            protocolMarshaller.marshall(profilerRuleConfiguration.getLocalPath(), LOCALPATH_BINDING);
            protocolMarshaller.marshall(profilerRuleConfiguration.getS3OutputPath(), S3OUTPUTPATH_BINDING);
            protocolMarshaller.marshall(profilerRuleConfiguration.getRuleEvaluatorImage(), RULEEVALUATORIMAGE_BINDING);
            protocolMarshaller.marshall(profilerRuleConfiguration.getInstanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall(profilerRuleConfiguration.getVolumeSizeInGB(), VOLUMESIZEINGB_BINDING);
            protocolMarshaller.marshall(profilerRuleConfiguration.getRuleParameters(), RULEPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

