/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.ProfilerConfig;
import java.util.Map;

@SdkInternalApi
public class ProfilerConfigMarshaller {
    private static final MarshallingInfo<String> S3OUTPUTPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3OutputPath").build();
    private static final MarshallingInfo<Long> PROFILINGINTERVALINMILLISECONDS_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProfilingIntervalInMilliseconds").build();
    private static final MarshallingInfo<Map> PROFILINGPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProfilingParameters").build();
    private static final MarshallingInfo<Boolean> DISABLEPROFILER_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisableProfiler").build();
    private static final ProfilerConfigMarshaller instance = new ProfilerConfigMarshaller();

    public static ProfilerConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProfilerConfig profilerConfig, ProtocolMarshaller protocolMarshaller) {
        if (profilerConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(profilerConfig.getS3OutputPath(), S3OUTPUTPATH_BINDING);
            protocolMarshaller.marshall(profilerConfig.getProfilingIntervalInMilliseconds(), PROFILINGINTERVALINMILLISECONDS_BINDING);
            protocolMarshaller.marshall(profilerConfig.getProfilingParameters(), PROFILINGPARAMETERS_BINDING);
            protocolMarshaller.marshall(profilerConfig.getDisableProfiler(), DISABLEPROFILER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

