/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.PipelineExecution;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class PipelineExecutionMarshaller {
    private static final MarshallingInfo<String> PIPELINEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PipelineArn").build();
    private static final MarshallingInfo<String> PIPELINEEXECUTIONARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PipelineExecutionArn").build();
    private static final MarshallingInfo<String> PIPELINEEXECUTIONDISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PipelineExecutionDisplayName").build();
    private static final MarshallingInfo<String> PIPELINEEXECUTIONSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PipelineExecutionStatus").build();
    private static final MarshallingInfo<String> PIPELINEEXECUTIONDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PipelineExecutionDescription").build();
    private static final MarshallingInfo<StructuredPojo> PIPELINEEXPERIMENTCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PipelineExperimentConfig").build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureReason").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> CREATEDBY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedBy").build();
    private static final MarshallingInfo<StructuredPojo> LASTMODIFIEDBY_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedBy").build();
    private static final MarshallingInfo<StructuredPojo> PARALLELISMCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParallelismConfiguration").build();
    private static final MarshallingInfo<StructuredPojo> SELECTIVEEXECUTIONCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SelectiveExecutionConfig").build();
    private static final MarshallingInfo<List> PIPELINEPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PipelineParameters").build();
    private static final PipelineExecutionMarshaller instance = new PipelineExecutionMarshaller();

    public static PipelineExecutionMarshaller getInstance() {
        return instance;
    }

    public void marshall(PipelineExecution pipelineExecution, ProtocolMarshaller protocolMarshaller) {
        if (pipelineExecution == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(pipelineExecution.getPipelineArn(), PIPELINEARN_BINDING);
            protocolMarshaller.marshall(pipelineExecution.getPipelineExecutionArn(), PIPELINEEXECUTIONARN_BINDING);
            protocolMarshaller.marshall(pipelineExecution.getPipelineExecutionDisplayName(), PIPELINEEXECUTIONDISPLAYNAME_BINDING);
            protocolMarshaller.marshall(pipelineExecution.getPipelineExecutionStatus(), PIPELINEEXECUTIONSTATUS_BINDING);
            protocolMarshaller.marshall(pipelineExecution.getPipelineExecutionDescription(), PIPELINEEXECUTIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall(pipelineExecution.getPipelineExperimentConfig(), PIPELINEEXPERIMENTCONFIG_BINDING);
            protocolMarshaller.marshall(pipelineExecution.getFailureReason(), FAILUREREASON_BINDING);
            protocolMarshaller.marshall(pipelineExecution.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(pipelineExecution.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall(pipelineExecution.getCreatedBy(), CREATEDBY_BINDING);
            protocolMarshaller.marshall(pipelineExecution.getLastModifiedBy(), LASTMODIFIEDBY_BINDING);
            protocolMarshaller.marshall(pipelineExecution.getParallelismConfiguration(), PARALLELISMCONFIGURATION_BINDING);
            protocolMarshaller.marshall(pipelineExecution.getSelectiveExecutionConfig(), SELECTIVEEXECUTIONCONFIG_BINDING);
            protocolMarshaller.marshall(pipelineExecution.getPipelineParameters(), PIPELINEPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

