/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.OidcConfig;
import java.util.Map;

@SdkInternalApi
public class OidcConfigMarshaller {
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").build();
    private static final MarshallingInfo<String> CLIENTSECRET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientSecret").build();
    private static final MarshallingInfo<String> ISSUER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Issuer").build();
    private static final MarshallingInfo<String> AUTHORIZATIONENDPOINT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthorizationEndpoint").build();
    private static final MarshallingInfo<String> TOKENENDPOINT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TokenEndpoint").build();
    private static final MarshallingInfo<String> USERINFOENDPOINT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserInfoEndpoint").build();
    private static final MarshallingInfo<String> LOGOUTENDPOINT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogoutEndpoint").build();
    private static final MarshallingInfo<String> JWKSURI_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JwksUri").build();
    private static final MarshallingInfo<String> SCOPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Scope").build();
    private static final MarshallingInfo<Map> AUTHENTICATIONREQUESTEXTRAPARAMS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthenticationRequestExtraParams").build();
    private static final OidcConfigMarshaller instance = new OidcConfigMarshaller();

    public static OidcConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(OidcConfig oidcConfig, ProtocolMarshaller protocolMarshaller) {
        if (oidcConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(oidcConfig.getClientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall(oidcConfig.getClientSecret(), CLIENTSECRET_BINDING);
            protocolMarshaller.marshall(oidcConfig.getIssuer(), ISSUER_BINDING);
            protocolMarshaller.marshall(oidcConfig.getAuthorizationEndpoint(), AUTHORIZATIONENDPOINT_BINDING);
            protocolMarshaller.marshall(oidcConfig.getTokenEndpoint(), TOKENENDPOINT_BINDING);
            protocolMarshaller.marshall(oidcConfig.getUserInfoEndpoint(), USERINFOENDPOINT_BINDING);
            protocolMarshaller.marshall(oidcConfig.getLogoutEndpoint(), LOGOUTENDPOINT_BINDING);
            protocolMarshaller.marshall(oidcConfig.getJwksUri(), JWKSURI_BINDING);
            protocolMarshaller.marshall(oidcConfig.getScope(), SCOPE_BINDING);
            protocolMarshaller.marshall(oidcConfig.getAuthenticationRequestExtraParams(), AUTHENTICATIONREQUESTEXTRAPARAMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

