/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.InferenceSpecification;
import java.util.List;

@SdkInternalApi
public class InferenceSpecificationMarshaller {
    private static final MarshallingInfo<List> CONTAINERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Containers").build();
    private static final MarshallingInfo<List> SUPPORTEDTRANSFORMINSTANCETYPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedTransformInstanceTypes").build();
    private static final MarshallingInfo<List> SUPPORTEDREALTIMEINFERENCEINSTANCETYPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedRealtimeInferenceInstanceTypes").build();
    private static final MarshallingInfo<List> SUPPORTEDCONTENTTYPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedContentTypes").build();
    private static final MarshallingInfo<List> SUPPORTEDRESPONSEMIMETYPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedResponseMIMETypes").build();
    private static final InferenceSpecificationMarshaller instance = new InferenceSpecificationMarshaller();

    public static InferenceSpecificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(InferenceSpecification inferenceSpecification, ProtocolMarshaller protocolMarshaller) {
        if (inferenceSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(inferenceSpecification.getContainers(), CONTAINERS_BINDING);
            protocolMarshaller.marshall(inferenceSpecification.getSupportedTransformInstanceTypes(), SUPPORTEDTRANSFORMINSTANCETYPES_BINDING);
            protocolMarshaller.marshall(inferenceSpecification.getSupportedRealtimeInferenceInstanceTypes(), SUPPORTEDREALTIMEINFERENCEINSTANCETYPES_BINDING);
            protocolMarshaller.marshall(inferenceSpecification.getSupportedContentTypes(), SUPPORTEDCONTENTTYPES_BINDING);
            protocolMarshaller.marshall(inferenceSpecification.getSupportedResponseMIMETypes(), SUPPORTEDRESPONSEMIMETYPES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

