/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.HubInfo;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class HubInfoMarshaller {
    private static final MarshallingInfo<String> HUBNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HubName").build();
    private static final MarshallingInfo<String> HUBARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HubArn").build();
    private static final MarshallingInfo<String> HUBDISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HubDisplayName").build();
    private static final MarshallingInfo<String> HUBDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HubDescription").build();
    private static final MarshallingInfo<List> HUBSEARCHKEYWORDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HubSearchKeywords").build();
    private static final MarshallingInfo<String> HUBSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HubStatus").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final HubInfoMarshaller instance = new HubInfoMarshaller();

    public static HubInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(HubInfo hubInfo, ProtocolMarshaller protocolMarshaller) {
        if (hubInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(hubInfo.getHubName(), HUBNAME_BINDING);
            protocolMarshaller.marshall(hubInfo.getHubArn(), HUBARN_BINDING);
            protocolMarshaller.marshall(hubInfo.getHubDisplayName(), HUBDISPLAYNAME_BINDING);
            protocolMarshaller.marshall(hubInfo.getHubDescription(), HUBDESCRIPTION_BINDING);
            protocolMarshaller.marshall(hubInfo.getHubSearchKeywords(), HUBSEARCHKEYWORDS_BINDING);
            protocolMarshaller.marshall(hubInfo.getHubStatus(), HUBSTATUS_BINDING);
            protocolMarshaller.marshall(hubInfo.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(hubInfo.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

