/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.FileSystemDataSource;

@SdkInternalApi
public class FileSystemDataSourceMarshaller {
    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemId").build();
    private static final MarshallingInfo<String> FILESYSTEMACCESSMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemAccessMode").build();
    private static final MarshallingInfo<String> FILESYSTEMTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemType").build();
    private static final MarshallingInfo<String> DIRECTORYPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DirectoryPath").build();
    private static final FileSystemDataSourceMarshaller instance = new FileSystemDataSourceMarshaller();

    public static FileSystemDataSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(FileSystemDataSource fileSystemDataSource, ProtocolMarshaller protocolMarshaller) {
        if (fileSystemDataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(fileSystemDataSource.getFileSystemId(), FILESYSTEMID_BINDING);
            protocolMarshaller.marshall(fileSystemDataSource.getFileSystemAccessMode(), FILESYSTEMACCESSMODE_BINDING);
            protocolMarshaller.marshall(fileSystemDataSource.getFileSystemType(), FILESYSTEMTYPE_BINDING);
            protocolMarshaller.marshall(fileSystemDataSource.getDirectoryPath(), DIRECTORYPATH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

