/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.ExperimentConfig;

@SdkInternalApi
public class ExperimentConfigMarshaller {
    private static final MarshallingInfo<String> EXPERIMENTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExperimentName").build();
    private static final MarshallingInfo<String> TRIALNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrialName").build();
    private static final MarshallingInfo<String> TRIALCOMPONENTDISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrialComponentDisplayName").build();
    private static final MarshallingInfo<String> RUNNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RunName").build();
    private static final ExperimentConfigMarshaller instance = new ExperimentConfigMarshaller();

    public static ExperimentConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExperimentConfig experimentConfig, ProtocolMarshaller protocolMarshaller) {
        if (experimentConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(experimentConfig.getExperimentName(), EXPERIMENTNAME_BINDING);
            protocolMarshaller.marshall(experimentConfig.getTrialName(), TRIALNAME_BINDING);
            protocolMarshaller.marshall(experimentConfig.getTrialComponentDisplayName(), TRIALCOMPONENTDISPLAYNAME_BINDING);
            protocolMarshaller.marshall(experimentConfig.getRunName(), RUNNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

