/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.EndpointInput;

@SdkInternalApi
public class EndpointInputMarshaller {
    private static final MarshallingInfo<String> ENDPOINTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointName").build();
    private static final MarshallingInfo<String> LOCALPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalPath").build();
    private static final MarshallingInfo<String> S3INPUTMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3InputMode").build();
    private static final MarshallingInfo<String> S3DATADISTRIBUTIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DataDistributionType").build();
    private static final MarshallingInfo<String> FEATURESATTRIBUTE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeaturesAttribute").build();
    private static final MarshallingInfo<String> INFERENCEATTRIBUTE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InferenceAttribute").build();
    private static final MarshallingInfo<String> PROBABILITYATTRIBUTE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProbabilityAttribute").build();
    private static final MarshallingInfo<Double> PROBABILITYTHRESHOLDATTRIBUTE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProbabilityThresholdAttribute").build();
    private static final MarshallingInfo<String> STARTTIMEOFFSET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTimeOffset").build();
    private static final MarshallingInfo<String> ENDTIMEOFFSET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTimeOffset").build();
    private static final MarshallingInfo<String> EXCLUDEFEATURESATTRIBUTE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludeFeaturesAttribute").build();
    private static final EndpointInputMarshaller instance = new EndpointInputMarshaller();

    public static EndpointInputMarshaller getInstance() {
        return instance;
    }

    public void marshall(EndpointInput endpointInput, ProtocolMarshaller protocolMarshaller) {
        if (endpointInput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(endpointInput.getEndpointName(), ENDPOINTNAME_BINDING);
            protocolMarshaller.marshall(endpointInput.getLocalPath(), LOCALPATH_BINDING);
            protocolMarshaller.marshall(endpointInput.getS3InputMode(), S3INPUTMODE_BINDING);
            protocolMarshaller.marshall(endpointInput.getS3DataDistributionType(), S3DATADISTRIBUTIONTYPE_BINDING);
            protocolMarshaller.marshall(endpointInput.getFeaturesAttribute(), FEATURESATTRIBUTE_BINDING);
            protocolMarshaller.marshall(endpointInput.getInferenceAttribute(), INFERENCEATTRIBUTE_BINDING);
            protocolMarshaller.marshall(endpointInput.getProbabilityAttribute(), PROBABILITYATTRIBUTE_BINDING);
            protocolMarshaller.marshall(endpointInput.getProbabilityThresholdAttribute(), PROBABILITYTHRESHOLDATTRIBUTE_BINDING);
            protocolMarshaller.marshall(endpointInput.getStartTimeOffset(), STARTTIMEOFFSET_BINDING);
            protocolMarshaller.marshall(endpointInput.getEndTimeOffset(), ENDTIMEOFFSET_BINDING);
            protocolMarshaller.marshall(endpointInput.getExcludeFeaturesAttribute(), EXCLUDEFEATURESATTRIBUTE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

