/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.EdgeModelStat;

@SdkInternalApi
public class EdgeModelStatMarshaller {
    private static final MarshallingInfo<String> MODELNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelName").build();
    private static final MarshallingInfo<String> MODELVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelVersion").build();
    private static final MarshallingInfo<Long> OFFLINEDEVICECOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OfflineDeviceCount").build();
    private static final MarshallingInfo<Long> CONNECTEDDEVICECOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectedDeviceCount").build();
    private static final MarshallingInfo<Long> ACTIVEDEVICECOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActiveDeviceCount").build();
    private static final MarshallingInfo<Long> SAMPLINGDEVICECOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SamplingDeviceCount").build();
    private static final EdgeModelStatMarshaller instance = new EdgeModelStatMarshaller();

    public static EdgeModelStatMarshaller getInstance() {
        return instance;
    }

    public void marshall(EdgeModelStat edgeModelStat, ProtocolMarshaller protocolMarshaller) {
        if (edgeModelStat == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(edgeModelStat.getModelName(), MODELNAME_BINDING);
            protocolMarshaller.marshall(edgeModelStat.getModelVersion(), MODELVERSION_BINDING);
            protocolMarshaller.marshall(edgeModelStat.getOfflineDeviceCount(), OFFLINEDEVICECOUNT_BINDING);
            protocolMarshaller.marshall(edgeModelStat.getConnectedDeviceCount(), CONNECTEDDEVICECOUNT_BINDING);
            protocolMarshaller.marshall(edgeModelStat.getActiveDeviceCount(), ACTIVEDEVICECOUNT_BINDING);
            protocolMarshaller.marshall(edgeModelStat.getSamplingDeviceCount(), SAMPLINGDEVICECOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

