/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.EFSFileSystem;

@SdkInternalApi
public class EFSFileSystemMarshaller {
    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemId").build();
    private static final EFSFileSystemMarshaller instance = new EFSFileSystemMarshaller();

    public static EFSFileSystemMarshaller getInstance() {
        return instance;
    }

    public void marshall(EFSFileSystem eFSFileSystem, ProtocolMarshaller protocolMarshaller) {
        if (eFSFileSystem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(eFSFileSystem.getFileSystemId(), FILESYSTEMID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

