/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.DomainDetails;
import java.util.Date;

@SdkInternalApi
public class DomainDetailsMarshaller {
    private static final MarshallingInfo<String> DOMAINARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainArn").build();
    private static final MarshallingInfo<String> DOMAINID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainId").build();
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Url").build();
    private static final DomainDetailsMarshaller instance = new DomainDetailsMarshaller();

    public static DomainDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(DomainDetails domainDetails, ProtocolMarshaller protocolMarshaller) {
        if (domainDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(domainDetails.getDomainArn(), DOMAINARN_BINDING);
            protocolMarshaller.marshall(domainDetails.getDomainId(), DOMAINID_BINDING);
            protocolMarshaller.marshall(domainDetails.getDomainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall(domainDetails.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(domainDetails.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(domainDetails.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall(domainDetails.getUrl(), URL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

