/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.DeviceStats;

@SdkInternalApi
public class DeviceStatsMarshaller {
    private static final MarshallingInfo<Long> CONNECTEDDEVICECOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectedDeviceCount").build();
    private static final MarshallingInfo<Long> REGISTEREDDEVICECOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegisteredDeviceCount").build();
    private static final DeviceStatsMarshaller instance = new DeviceStatsMarshaller();

    public static DeviceStatsMarshaller getInstance() {
        return instance;
    }

    public void marshall(DeviceStats deviceStats, ProtocolMarshaller protocolMarshaller) {
        if (deviceStats == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(deviceStats.getConnectedDeviceCount(), CONNECTEDDEVICECOUNT_BINDING);
            protocolMarshaller.marshall(deviceStats.getRegisteredDeviceCount(), REGISTEREDDEVICECOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

