/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.DebugHookConfig;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class DebugHookConfigMarshaller {
    private static final MarshallingInfo<String> LOCALPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalPath").build();
    private static final MarshallingInfo<String> S3OUTPUTPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3OutputPath").build();
    private static final MarshallingInfo<Map> HOOKPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HookParameters").build();
    private static final MarshallingInfo<List> COLLECTIONCONFIGURATIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CollectionConfigurations").build();
    private static final DebugHookConfigMarshaller instance = new DebugHookConfigMarshaller();

    public static DebugHookConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(DebugHookConfig debugHookConfig, ProtocolMarshaller protocolMarshaller) {
        if (debugHookConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(debugHookConfig.getLocalPath(), LOCALPATH_BINDING);
            protocolMarshaller.marshall(debugHookConfig.getS3OutputPath(), S3OUTPUTPATH_BINDING);
            protocolMarshaller.marshall(debugHookConfig.getHookParameters(), HOOKPARAMETERS_BINDING);
            protocolMarshaller.marshall(debugHookConfig.getCollectionConfigurations(), COLLECTIONCONFIGURATIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

