/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.DataCatalogConfig;

@SdkInternalApi
public class DataCatalogConfigMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<String> CATALOG_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Catalog").build();
    private static final MarshallingInfo<String> DATABASE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Database").build();
    private static final DataCatalogConfigMarshaller instance = new DataCatalogConfigMarshaller();

    public static DataCatalogConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataCatalogConfig dataCatalogConfig, ProtocolMarshaller protocolMarshaller) {
        if (dataCatalogConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dataCatalogConfig.getTableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(dataCatalogConfig.getCatalog(), CATALOG_BINDING);
            protocolMarshaller.marshall(dataCatalogConfig.getDatabase(), DATABASE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

