/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.ContainerConfig;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ContainerConfigMarshaller {
    private static final MarshallingInfo<List> CONTAINERARGUMENTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContainerArguments").build();
    private static final MarshallingInfo<List> CONTAINERENTRYPOINT_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContainerEntrypoint").build();
    private static final MarshallingInfo<Map> CONTAINERENVIRONMENTVARIABLES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContainerEnvironmentVariables").build();
    private static final ContainerConfigMarshaller instance = new ContainerConfigMarshaller();

    public static ContainerConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContainerConfig containerConfig, ProtocolMarshaller protocolMarshaller) {
        if (containerConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(containerConfig.getContainerArguments(), CONTAINERARGUMENTS_BINDING);
            protocolMarshaller.marshall(containerConfig.getContainerEntrypoint(), CONTAINERENTRYPOINT_BINDING);
            protocolMarshaller.marshall(containerConfig.getContainerEnvironmentVariables(), CONTAINERENVIRONMENTVARIABLES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

